if ('scrollRestoration' in history) {
	history.scrollRestoration = 'manual';
}

document.addEventListener('DOMContentLoaded', function () {
	const coreValuesTitles = document.querySelectorAll('.coreValues_title');

	coreValuesTitles.forEach((title, id) => {
		title.addEventListener('click', function () {
			const content = this.nextElementSibling;
			const isActive = content.classList.contains('active_content');
			closeAllContent();
			content.classList.toggle('active_content');
			// console.log(content.classList);
		});
	});

	function closeAllContent() {
		const contents = document.querySelectorAll('.content');
		contents.forEach((content) => {
			content.classList.remove('active_content');
		});
	}
});

document.addEventListener('DOMContentLoaded', (event) => {
	gsap.registerPlugin(ScrollTrigger, ScrollToPlugin);
	// gsap code here!

	gsap.fromTo(
		'#who_we_are .right',
		{
			y: 100,
			x: -100,
		},
		{
			y: 0,
			x: 0,
			duration: 1,
			ease: 'power2.out',
			delay: 0.2,
			scrollTrigger: {
				trigger: '#who_we_are',
				start: 'top bottom', // Trigger animation when the top of .testimony_sect reaches the bottom of the viewport
				end: 'bottom top', // End animation when the bottom of .testimony_sect reaches the top of the viewport
				// markers: true, // Add markers to visualize trigger and animation
				toggleActions: 'play none none none', // Play the animation once on scroll
			},
		}
	);
	gsap.fromTo(
		'#who_we_are .left',
		{
			y: 100,
			x: 100,
		},
		{
			y: 0,
			x: 0,
			duration: 1,
			ease: 'power2.out',
			delay: 0.2,
			scrollTrigger: {
				trigger: '#who_we_are',
				start: 'top bottom', // Trigger animation when the top of .testimony_sect reaches the bottom of the viewport
				end: 'bottom top', // End animation when the bottom of .testimony_sect reaches the top of the viewport
				// markers: true, // Add markers to visualize trigger and animation
				toggleActions: 'play none none none', // Play the animation once on scroll
			},
		}
	);
	gsap.fromTo(
		'.missionVision',
		{
			y: 100,
		},
		{
			y: 0,
			duration: 1,
			ease: 'power2.out',
			delay: 0.2,
			scrollTrigger: {
				trigger: '.missionVision',
				start: 'top bottom', // Trigger animation when the top of .testimony_sect reaches the bottom of the viewport
				end: 'bottom top', // End animation when the bottom of .testimony_sect reaches the top of the viewport
				// markers: true, // Add markers to visualize trigger and animation
				toggleActions: 'play none none none', // Play the animation once on scroll
			},
		}
	);
	gsap.fromTo(
		'.coreValues li',
		{
			y: 100,
		},
		{
			y: 0,
			duration: 1,
			ease: 'power2.out',
			delay: 0.2,
			stagger: 0.1,
			scrollTrigger: {
				trigger: '.coreValues',
				start: 'top bottom', // Trigger animation when the top of .testimony_sect reaches the bottom of the viewport
				end: 'bottom top', // End animation when the bottom of .testimony_sect reaches the top of the viewport
				// markers: true, // Add markers to visualize trigger and animation
				toggleActions: 'play none none none', // Play the animation once on scroll
			},
		}
	);
	gsap.fromTo(
		'#team',
		{
			y: 100,
		},
		{
			y: 0,
			duration: 1,
			ease: 'power2.out',
			delay: 0.2,
			scrollTrigger: {
				trigger: '#team',
				start: 'top bottom', // Trigger animation when the top of .testimony_sect reaches the bottom of the viewport
				end: 'bottom top', // End animation when the bottom of .testimony_sect reaches the top of the viewport
				// markers: true, // Add markers to visualize trigger and animation
				toggleActions: 'play none none none', // Play the animation once on scroll
			},
		}
	);
	gsap.fromTo(
		'.ourBrand',
		{
			y: 100,
		},
		{
			y: 0,
			duration: 1,
			ease: 'power2.out',
			delay: 0.2,
			scrollTrigger: {
				trigger: '.ourBrand',
				start: 'top bottom', // Trigger animation when the top of .testimony_sect reaches the bottom of the viewport
				end: 'bottom top', // End animation when the bottom of .testimony_sect reaches the top of the viewport
				// markers: true, // Add markers to visualize trigger and animation
				toggleActions: 'play none none none', // Play the animation once on scroll
			},
		}
	);
});


