// gsap-animations.js

gsap.from(".ourBusinessName", {
  x: 100,
  opacity: 0,
  duration: 1,
  ease: "power3.out",
  delay: 0.8
});




// Animate the header elements on page load
gsap.from("#site-header", {
  y: -100,
  opacity: 0,
  duration: 1,
  ease: "power3.out"
});

// Animate the logo
gsap.from(".logo-brand", {
  x: -200,
  opacity: 0,
  duration: 1.5,
  ease: "power3.out",
  delay: 0.2
});

// Animate the navigation menu
gsap.from(".main-navigation ul li", {
  opacity: 0,
  y: 20,
  duration: 1,
  ease: "power3.out",
  stagger: 0.1, // Stagger the animation of each menu item
  delay: 0.4
});

// Animate the page title on load
gsap.from(".page-title", {
  y: 50,
  opacity: 0,
  duration: 1.2,
  ease: "power3.out",
  delay: 0.6
});

// Animate the project slider (if exists)
gsap.from(".project-slider", {
  x: 100,
  opacity: 0,
  duration: 1,
  ease: "power3.out",
  delay: 0.8
});

// Animate images as they come into view
gsap.utils.toArray("img").forEach((img) => {
  gsap.from(img, {
    scrollTrigger: {
      trigger: img,
      start: "top 80%", // Start the animation when the image is 80% into view
      toggleActions: "play none none none" // Play the animation only once
    },
    y: 50,
    opacity: 0,
    duration: 1,
    ease: "power3.out"
  });
});

// Hamburger menu animation for mobile view
const menuToggle = document.getElementById("menu-toggle");
const mobileMenu = document.getElementById("mobile-menu");

menuToggle.addEventListener("click", () => {
  const isOpen = mobileMenu.style.display === "block";

  gsap.to(mobileMenu, {
    display: isOpen ? "none" : "block",
    opacity: isOpen ? 0 : 1,
    duration: 0.5,
    ease: "power3.out"
  });
  
  gsap.to(menuToggle, {
    rotation: isOpen ? 0 : 90,
    duration: 0.5,
    ease: "power3.out"
  });
});
