// jQuery(document).ready(function () {
// 	'use strict';
// 	aci_holdings_contact_form();
// });
// function aci_holdings_contact_form() {
// 	'use strict';

// 	jQuery('.contact_form #send_message').on('click', function (e) {
// 		e.preventDefault();
// 		let name = jQuery('.contact_form #name').val();
// 		let email = jQuery('.contact_form #email').val();
// 		let message = jQuery('.contact_form #message').val();
// 		let phone = jQuery('.contact_form #phone').val();
// 		let success = jQuery('.contact_form .returnmessage').data('success');
// 		let service_id = 'service_fi669df';
// 		let template_id = 'template_akjs5xj';

// 		jQuery('.contact_form .returnmessage').empty(); //To empty previous error/success message.
// 		//checking for blank fields
// 		if (name === '' || email === '') {
// 			jQuery('div.empty_notice').slideDown(500).delay(2000).slideUp(500);
// 		} else {
// 			// using emailJs
// 			const params = {
// 				name,
// 				email,
// 				phone,
// 				message,
// 			};
// 			emailjs
// 				.send(service_id, template_id, params)
// 				.then((res) => {
// 					// Returns successful data submission message when the entered information is stored in database.
// 					jQuery('.contact_form .returnmessage').append(
// 						"<span class='contact_success'>" + success + '</span>'
// 					);
// 					jQuery('.contact_form .returnmessage')
// 						.slideDown(500)
// 						.delay(4000)
// 						.slideUp(500);
// 				})
// 				.then((res) => {
// 					name = '';
// 					email = '';
// 					message = '';
// 					phone = '';
// 				});
// 		}
// 		return false;
// 	});
// }

jQuery(document).ready(function () {
	'use strict';
	aci_holdings_contact_form();
});

function aci_holdings_contact_form() {
	'use strict';

	jQuery('.contact_form #send_message').on('click', function (e) {
		e.preventDefault();
		let name = jQuery('.contact_form #name').val();
		let email = jQuery('.contact_form #email').val();
		let message = jQuery('.contact_form #message').val();
		let phone = jQuery('.contact_form #phone').val();
		let success = jQuery('.contact_form .returnmessage').data('success');
		let service_id = 'service_fi669df';
		let template_id = 'template_akjs5xj';

		jQuery('.contact_form .returnmessage').empty(); //To empty previous error/success message.

		// checking for blank fields
		if (name === '' || email === '') {
			jQuery('div.empty_notice').slideDown(500).delay(2000).slideUp(500);
		} else {
			// using emailJs
			const params = {
				name,
				email,
				phone,
				message,
			};
			emailjs
				.send(service_id, template_id, params)
				.then((res) => {
					// Returns successful data submission message when the entered information is stored in database.
					jQuery('.contact_form .returnmessage').append(
						"<span class='contact_success'>" + success + '</span>'
					);
					jQuery('.contact_form .returnmessage')
						.slideDown(500)
						.delay(4000)
						.slideUp(500);

					// Clear the input fields
					jQuery('.contact_form #name').val('');
					jQuery('.contact_form #email').val('');
					jQuery('.contact_form #message').val('');
					jQuery('.contact_form #phone').val('');
				})
				.catch((err) => {
					console.error('Failed to send email:', err);
				});
		}
		return false;
	});
}
