

// Function to create the modal dynamically
function createModal() {
  // Create the modal container
  const modal = document.createElement('div');
  modal.id = 'imageModal';
  modal.classList.add('modal');

  // Create the close button
  const closeButton = document.createElement('span');
  closeButton.classList.add('close');
  closeButton.innerHTML = '&times;';
  closeButton.addEventListener('click', closeModal);

  // Create the image inside the modal
  const modalImage = document.createElement('img');
  modalImage.classList.add('modal-content');
  modalImage.id = 'modalImage';

  // Create the prev and next buttons
  const prevButton = document.createElement('span');
  prevButton.classList.add('prev');
  prevButton.innerHTML = '&#10094;';
  prevButton.addEventListener('click', showPrevImage);

  const nextButton = document.createElement('span');
  nextButton.classList.add('next');
  nextButton.innerHTML = '&#10095;';
  nextButton.addEventListener('click', showNextImage);

  // Append all the elements to the modal container
  modal.appendChild(closeButton);
  modal.appendChild(modalImage);
  modal.appendChild(prevButton);
  modal.appendChild(nextButton);

  // Append the modal to the body of the document
  document.body.appendChild(modal);
}

// Call the function to create the modal
createModal();

// Function to open the modal with the clicked image
let currentIndex;
const images = document.querySelectorAll(".clickable-image");

function openModal(index) {
  const modal = document.getElementById('imageModal');
  const modalImage = document.getElementById('modalImage');
  modal.style.display = "flex";
  modal.classList.add('active');  // Use 'active' instead of 'show'
  modalImage.src = images[index].src;
  currentIndex = index;
}

// Function to close the modal
function closeModal() {
  const modal = document.getElementById('imageModal');
  modal.style.display = "none";
  modal.classList.remove('active');  // Use 'active' instead of 'show'
}

// Function to show the next image
function showNextImage() {
  currentIndex = (currentIndex + 1) % images.length;
  const modalImage = document.getElementById('modalImage');
  modalImage.src = images[currentIndex].src;
}

// Function to show the previous image
function showPrevImage() {
  currentIndex = (currentIndex - 1 + images.length) % images.length;
  const modalImage = document.getElementById('modalImage');
  modalImage.src = images[currentIndex].src;
}

// Add click event to each image
images.forEach((image, index) => {
  image.addEventListener("click", function() {
    openModal(index);
  });
});

// Close modal when clicking outside the image
window.addEventListener("click", function(event) {
  const modal = document.getElementById('imageModal');
  if (event.target === modal) {
    closeModal();
  }
});

// Navigate through images with keyboard (optional)
window.addEventListener('keydown', function(event) {
  if (event.key === 'ArrowRight') {
    showNextImage();
  } else if (event.key === 'ArrowLeft') {
    showPrevImage();
  } else if (event.key === 'Escape') {
    closeModal();
  }
});
