document.addEventListener('DOMContentLoaded', (event) => {
	gsap.registerPlugin(ScrollTrigger, ScrollToPlugin);
	// gsap code here!

	gsap.fromTo(
		'#hero_elem .hero_text',
		{
			y: 100,
			x: 0,
            opacity: 0.5
		},
		{
			y: '-40%',
			x: 0,
            opacity: 1,
			duration: 2.5,
			ease: 'power2.out',
			delay: 0.4,
			scrollTrigger: {
				trigger: '#hero_elem',
				start: 'top bottom',
				end: 'bottom top',
				toggleActions: 'play none none none',
			},
		}
	);
	gsap.fromTo(
		'#services_section .services-slider',
		{
			y: 100,
			x: 0,
		},
		{
			y: 0,
			x: 0,
			duration: 2.5,
			ease: 'power2.out',
			delay: 0.4,
			scrollTrigger: {
				trigger: '#services_section',
				end: 'bottom top', 
				toggleActions: 'play none none none'
			},
		}
	);
	gsap.fromTo(
		'#services_section .section_header',
		{
			x: '-40%',
            opacity: 0.7
		},
		{
			x: 0,
			duration: 2.5,
            opacity: 1,
			ease: 'power2.out',
			delay: 0.4,
			scrollTrigger: {
				trigger: '#services_section',
				start: 'top bottom',
				end: 'bottom top',
				toggleActions: 'play none none none',
			},
		}
	);
	gsap.fromTo(
		'#about_section .block-right',
		{
			y: 100,
            opacity: 0.7
		},
		{
			y: 0,
			duration: 2,
            opacity: 1,
			ease: 'power2.out',
			delay: 0.4,
			scrollTrigger: {
				trigger: '#about_section',
				start: 'top bottom',
				end: 'bottom top',
				toggleActions: 'play none none none',
			},
		}
	);
	gsap.fromTo(
		'#partners_section .businesses_logo',
		{
            opacity: 0
		},
		{
			duration: 4,
            opacity: 1,
			ease: 'power2.out',
			delay: 0.4,
			scrollTrigger: {
				trigger: '#partners_section',
				start: 'top bottom',
				end: 'bottom top',
				toggleActions: 'play none none none',
			},
		}
	);
	gsap.fromTo(
		'#contact_section .animate_top',
		{
			y: 100,
			x: 0,
            opacity: 0.5
		},
		{
			y: 0,
			x: 0,
            opacity: 1,
			duration: 2.5,
			ease: 'power2.out',
			delay: 0.4,
			scrollTrigger: {
				trigger: '#contact_section',
				start: 'top bottom',
				end: 'bottom top',
				toggleActions: 'play none none none',
			},
		}
	);
	gsap.fromTo(
		'#news_section .section_header',
		{
			x: '-40%',
            opacity: 0.7
		},
		{
			x: 0,
			duration: 2.5,
            opacity: 1,
			ease: 'power2.out',
			delay: 0.4,
			scrollTrigger: {
				trigger: '#news_section',
				start: 'top bottom',
				end: 'bottom top',
				toggleActions: 'play none none none',
			},
		}
	);
    gsap.fromTo(
		'#news_card_section .col-md-4',
		{
			y: 100,
			x: 0,
            opacity: 0.5
		},
		{
			y: 0,
			x: 0,
            opacity: 1,
			duration: 2.5,
			ease: 'power2.out',
			delay: 0.4,
			scrollTrigger: {
				trigger: '#news_card_section',
				start: 'top bottom',
				end: 'bottom top',
				toggleActions: 'play none none none',
			},
		}
	);
});
