const getTeamData = async () => {
	try {
		const response = await fetch(
			'https://cdn.contentful.com/spaces/nj0pejd87eth/entries?access_token=KpS4M0hN9RnrPxxnnugGVp7ddMHvRCudPOGlSxdDlVE'
		);

		if (!response.ok) {
			throw new Error('Network response was not ok');
		}

		const data = await response.json();
		return data;
	} catch (error) {
		console.error('Error fetching data:', error.message);
	}
};

document.addEventListener('DOMContentLoaded', async () => {
	const newsList = await getTeamData();
	let newsListData = [];

	const urlString = window.location.href;

	const url = new URL(urlString);

	// Get the search params
	const searchParams = url.searchParams;

	// Access individual parameters
	const param = searchParams.get('category');

	if (param) {
		newsListData = newsList.items.filter(
			(item) => {
				return item.fields ? .category &&
					item.fields.category.replaceAll(' ', '-').replaceAll('&', 'and').toLowerCase() === param.toLowerCase()
			}
		);
	} else {
		newsListData = newsList.items;
	}

	const newsSection = document.querySelector('.news-content');

	const newsCategory = [];

	newsList.items.forEach(newsData => {
		if (
			!newsCategory.includes(newsData.fields.category) &&
			newsData.fields.category
		) {
			newsCategory.push(newsData.fields.category);
		}
	})

	newsListData.forEach((newsData, idx) => {
		const newsDiv = document.createElement('article');
		newsDiv.className = 'post-box post type-post entry';

		if (newsData.sys.contentType.sys.id === 'acinews') {
			const profileNewsObj = newsList.includes.Asset.filter(
				(item) => item.sys.id === newsData.fields.image.sys.id
			)[0];

			// newsDiv.classList.add('row');

			let newsCardInfo = `
                  <div class="entry-media">
											<a href="post.html">
												<img loading="lazy"
													src=${profileNewsObj.fields.file.url}
													alt=""
												/>
											</a>
										</div>
										<div class="inner-post">
											<header class="entry-header">
												<div class="entry-meta">
													<span class="posted-on">
														<span class="entry-date published"
															>${new Date(newsData.sys.createdAt).toLocaleDateString()}</span
														>
													</span>
													<span class="posted-in">
														<a href="#" rel="category tag">
														${newsData.fields.category}
														</a>
													</span>
												</div>
												<!-- .entry-meta -->
												<h3 class="entry-title">
													<a href="post.html" rel="bookmark"
														>
														${newsData.fields.title}
														</a
													>
												</h3>
											</header>
											<!-- .entry-header -->

											<div class="entry-summary">
												<p>
													${newsData.fields.paragraph}
												</p>
											</div>
											<!-- .entry-content -->

											<footer class="entry-footer">
												<a class="post-link" href="post.html"
													>Read more<i
														class="icon ion-md-add-circle-outline"
													></i
												></a>
											</footer>
											<!-- .entry-footer -->
										</div>
      `;

			newsDiv.innerHTML = newsCardInfo;

			newsSection.appendChild(newsDiv);
		}
	});

	if (newsCategory.length > 0) {
		const newCategoryList = document.querySelector('.category-list');

		newsCategory.forEach((item, index) => {
			const listItem = document.createElement('li');
			listItem.className = `cat-item cat-item-${index}`;

			let listLink = item.replaceAll(' ', '-');
			listLink = listLink.replaceAll('&', 'and');

			const listContent = `
		<a href="/news.html?category=${listLink}">${item}</a>
		`;

			listItem.innerHTML = listContent;
			newCategoryList.appendChild(listItem);
		});
	}
});

// /spaces/{space_id}/environments/{environment_id}/entries/{entry_id}?access_token={access_token}