document.addEventListener('DOMContentLoaded', () => {
  gsap.registerPlugin(ScrollTrigger);

  // Animate '.page-title'
  gsap.fromTo(
    '.page-title', {
      y: 100,
      opacity: 0,
    }, {
      y: 0,
      opacity: 1,
      duration: 1,
      ease: 'power2.out',
      scrollTrigger: {
        trigger: '.page-title',
        start: 'top 80%',
        end: 'bottom top',
        toggleActions: 'play none none none', // Play only when scrolling down
        once: true, // Ensures the animation triggers only once
      },
    }
  );

  // Animate '.row'
  gsap.fromTo(
    '.row', {
      x: '-100%',
      opacity: 0,
    }, {
      x: '0%',
      opacity: 1,
      duration: 1,
      ease: 'power2.out',
      scrollTrigger: {
        trigger: '.row',
        start: 'top 80%',
        toggleActions: 'play none none none', // Play only when scrolling down
        once: true, // Ensures the animation triggers only once
      },
    }
  );

  // Animate '.grp_biz_items.left'
  gsap.fromTo(
    '.grp_biz_items', {
      y: 100,
      // opacity: 0,
    }, {
      y: 0,
      // opacity: 1,
      duration: 1,
      ease: 'power2.out',
      stagger: 0.3,
      scrollTrigger: {
        trigger: '.grp_businesses_flex',
        start: 'top 80%',
        toggleActions: 'play none none none', // Play only when scrolling down
        once: true, // Ensures the animation triggers only once
        stagger: 0.2,
      },
    }
  );

  // Animate '.grp_biz_items.right'
  // gsap.fromTo(
  //   '.grp_biz_items',
  //   {
  //     x: 100,
  //     opacity: 0,
  //   },
  //   {
  //     x: 0,
  //     opacity: 1,
  //     duration: 1,
  //     ease: 'power2.out',
  //     scrollTrigger: {
  //       trigger: '.grp_businesses_flex',
  //       start: 'top 80%',
  //       toggleActions: 'play none none none',  // Play only when scrolling down
  //       once: true,  // Ensures the animation triggers only once
  //       stagger: 0.2,
  //     },
  //   }
  // );
});