(function ($) {
	('use strict');

	// single business details
	$(document).ready(function () {
		// Retrieve the ID from the URL
		var urlParams = new URLSearchParams(window.location.search);
		var id = urlParams.get('id');

		// Fetch the unique information based on the ID
		$.getJSON('business.json', function (data) {
			let uniqueInfo = data.data;
			let uniquePageInfo = [];
			uniqueInfo.map((item) => {
				item.id === Number(id) ? uniquePageInfo.push(item) : null;
			});

			// console.log(uniquePageInfo);

			if (uniquePageInfo[0] !== null || uniquePageInfo[0] !== undefined) {
				// Get the "card-slide-one" and "card-slide-two" elements
				let imgSlideOne = document.querySelector('.card-slide-one');
				// get the hero section element
				let heroHeader = document.querySelector('.page-header');
				// Check if the element exist and if card_image_slide is defined
				if (imgSlideOne) {
					// Set the background image of the first slide
					imgSlideOne.style.backgroundImage = `url(${uniquePageInfo[0].card_image_slide_one})`;
				}
				console.log(heroHeader);
				if (heroHeader) {
					// Set the background image of the first slide
					heroHeader.style.backgroundImage = `url(${uniquePageInfo[0].card_image})`;
				}

				let businessDetails = `
	<div class='row'>
			<div class='col-md-12'>
				${uniquePageInfo[0].content}
			</div>
		</div>`;

				document.getElementById('businessPageTitle').innerText =
					uniquePageInfo[0].name;
				document.getElementById(
					'ourBusinessName'
				).innerText = ` About ${uniquePageInfo[0].abbr}`;

				$('#proj_details_custom').append(businessDetails);

				let businessDetailServices = document.getElementById(
					'businessDetailServices'
				);
				if (
					uniquePageInfo[0].service !== '' ||
					uniquePageInfo[0].service.length > 0
				) {
					businessDetailServices.innerHTML = uniquePageInfo[0].service;
				} else {
					businessDetailServices.style.display = 'none';
				}
			}
		});
	});
})(jQuery);
