document.addEventListener('DOMContentLoaded', (event) => {
	gsap.registerPlugin(ScrollTrigger, ScrollToPlugin);
	// gsap code here!

	gsap.fromTo(
		'#inclusion .inclusionRight .content',
		{
			y: 100,
			x: -100,
		},
		{
			y: 0,
			x: 0,
			duration: 1,
			ease: 'power2.out',
			delay: 0.2,
			scrollTrigger: {
				trigger: '#inclusion .inclusionRight',
				start: 'top bottom', // Trigger animation when the top of .testimony_sect reaches the bottom of the viewport
				end: 'bottom top', // End animation when the bottom of .testimony_sect reaches the top of the viewport
				// markers: true, // Add markers to visualize trigger and animation
				toggleActions: 'play none none none', // Play the animation once on scroll
			},
		}
	);
	gsap.fromTo(
		'#inclusion .inclusionRight .inclusion-img ',
		{
			y: 100,
			x: 100,
		},
		{
			y: 0,
			x: 0,
			duration: 1,
			ease: 'power2.out',
			delay: 0.2,
			scrollTrigger: {
				trigger: '#inclusion .inclusionRight',
				start: 'top bottom', // Trigger animation when the top of .testimony_sect reaches the bottom of the viewport
				end: 'bottom top', // End animation when the bottom of .testimony_sect reaches the top of the viewport
				// markers: true, // Add markers to visualize trigger and animation
				toggleActions: 'play none none none', // Play the animation once on scroll
			},
		}
	);
	gsap.fromTo(
		'#inclusion .inclusionLeft .content',
		{
			y: 100,
			x: 100,
		},
		{
			y: 0,
			x: 0,
			duration: 1,
			ease: 'power2.out',
			delay: 0.2,
			scrollTrigger: {
				trigger: '#inclusion .inclusionLeft',
				start: 'top bottom', // Trigger animation when the top of .testimony_sect reaches the bottom of the viewport
				end: 'bottom top', // End animation when the bottom of .testimony_sect reaches the top of the viewport
				// markers: true, // Add markers to visualize trigger and animation
				toggleActions: 'play none none none', // Play the animation once on scroll
			},
		}
	);
	gsap.fromTo(
		'#inclusion .inclusionLeft .inclusion-img ',
		{
			y: 100,
			x: -100,
		},
		{
			y: 0,
			x: 0,
			duration: 1,
			ease: 'power2.out',
			delay: 0.2,
			scrollTrigger: {
				trigger: '#inclusion .inclusionLeft',
				start: 'top bottom', // Trigger animation when the top of .testimony_sect reaches the bottom of the viewport
				end: 'bottom top', // End animation when the bottom of .testimony_sect reaches the top of the viewport
				// markers: true, // Add markers to visualize trigger and animation
				toggleActions: 'play none none none', // Play the animation once on scroll
			},
		}
	);
	
});
