document.addEventListener('DOMContentLoaded', async () => {
	function getQueryParams() {
		const params = new URLSearchParams(window.location.search);
		const id = params.get('id');
		const type = params.get('type');
		return {
			id,
			type
		};
	}

	const getTeamMemberData = async () => {
		const {
			id,
			type
		} = getQueryParams();
		try {
			const response = await fetch(`mgtProfiles.json`);

			if (!response.ok) {
				throw new Error('Network response was not ok');
			}
			const data = await response.json();

			let teamMembers = [];

			// Check type and assign the corresponding array
			if (type === 'mgt') {
				teamMembers = data.mgt;
			} else if (type === 'sub') {
				teamMembers = data.subMgt;
			} else {
				throw new Error('Invalid type provided');
			}

			// Find the team member with matching id in the selected array
			const teamMember = teamMembers.find((member) => member.id === Number(id));
			displayMemberDetails(teamMember);
		} catch (error) {
			console.error('Error fetching data:', error.message);
			return null; // Return null in case of error
		}
	};

	// Function to display the member details
	function displayMemberDetails(member) {
		const memberDetails = document.getElementById('member-section');
		// console.log(member);
		if (member) {
			memberDetails.innerHTML = `
			<div class="member-title">
					<h4>About Us / <span class="member-name">${member.name}</span></h4>
			</div>
		<div class="member-info">
						<div class="member-image-div">

							<div class="member-image">
								<img loading="lazy" src="${member.img}" class="member-profile-img" alt="image" />
							</div>
						</div>

						<div class="member-content">
							<h3 class="member-name">${member.name}</h3>

							<p class="member-position">${member.role}</p>

							<div class="member-about">${member.desc[0]}</div>
						</div>
					</div>
					<div class="member-description">${member.desc[1]}</div>
`;
		} else {
			memberDetails.innerHTML = `<p>Member not found.</p>`;
		}
	}

	// Fetch member details when the page loads
	getTeamMemberData();
});