// swiper-config.js
document.addEventListener('DOMContentLoaded', function () {

    const swiper = new Swiper('.swiper', {
        slidesPerView: 3,
        // Optional parameters
        loop: true,
        // autoplay: true,
        // speed: 5000,

        // Navigation arrows
        navigation: {
            nextEl: '.forward',
            prevEl: '.backwards',
        },

        on: {
            slideChange: function () {
                handleActiveSlideChange(this.realIndex);
            },
        },
    });

    function handleActiveSlideChange(activeIndex) {
        console.log('Current active slide index:', activeIndex);
        // Call another function with the active index
        displayDivForActiveIndex(activeIndex);
    }

    function displayDivForActiveIndex(index) {
        // Hide all section-content divs
        const allDivs = document.querySelectorAll('.section-content');
        allDivs.forEach(div => {
            div.classList.remove('active');
        });

        // Show the div corresponding to the active slide index
        const targetDiv = document.getElementsByClassName(`content-${index}`);
        if (targetDiv.length > 0) {
            targetDiv[0].classList.add('active');
        }
    }
});